import React, { useEffect } from "react";
import Image from "next/image";
import image1 from "../../../../../public/assets/dashboard/video.png";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faVideo } from "@fortawesome/free-solid-svg-icons";
import { faClock } from "@fortawesome/free-regular-svg-icons";
import { faEye } from "@fortawesome/free-solid-svg-icons";
import { faPlay } from "@fortawesome/free-solid-svg-icons";
import { fetchEnrolledCourses } from "@/newStore/features/enrolledCoursesSlice";
import { inProgress as inProgressSlice } from "@/newStore/features/inProgressSlice";
import { useSelector, useDispatch } from "react-redux";
import LoaderCircle from "../../loaderCircle/loaderCircle";
import { BASE_IMAGE_URL } from "@/services/ApiEndpoints";
import Link from "next/link";

export default function EnrolledDashboardCourses() {
  const dispatch = useDispatch();

  const enrolledCourses = useSelector(
    (state) => state.enrolledCourses.enrolledCourses
  );

  
  const enrolledCoursesLoader = useSelector(
    (state) => state.inProgress.isLoading
  );

  useEffect(() => {
    const loadData = async () => {
      await Promise.all([dispatch(fetchEnrolledCourses())]);
    };
    loadData();
  }, [dispatch]);

  function secondsToHMS(seconds) {
    const hours = Math.floor(seconds / 3600);
    const minutes = Math.floor((seconds % 3600) / 60);
    const remainingSeconds = seconds % 60;

    return `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${remainingSeconds.toString().padStart(2, '0')}`;
}

  return (
    <>
      {enrolledCourses === null ? (
        <div className="pr-2 h-[280px] flex justify-center items-center">
          <LoaderCircle />
        </div>
      ) : (
        <>
        {enrolledCourses?.courses?.length > 0 ? (
          <div className="overflow-y-auto pr-2 h-[280px] customScrollbar">
            <table className="min-w-full">
              <tbody>
                {enrolledCourses?.courses?.map((course, index) => (
                    <tr
                      key={index}
                      className={`border-b ${
                        index === course?.length - 1 ? "" : "border-[#c7c7c7]"
                      } hover:bg-[#eee] transition-colors duration-200`}
                    >
                      <td className="p-2 w-20">
                        <Link href={`/courses/${course?.id}`}>
                        {/* <Image
                          src={BASE_IMAGE_URL + course?.image}
                          alt="video"
                          className="rounded-full h-[60px] w-[60px] object-cover"
                        /> */}
                        {course?.image === null ? (
                        <Image
                          className="rounded-full h-[60px] w-[60px] object-cover"
                          src={image1}
                          alt="image"
                          layout="responsive"
                        />
                      ) : (
                        <img
                          className="rounded-full h-[60px] w-[60px] object-cover"
                          src={BASE_IMAGE_URL + course?.image}
                          alt="image"
                          loading="lazy"
                          // width={"100"}
                          // height={"100"}
                        />
                      )}
                      </Link>
                      </td>
                      <td className="p-2">
                        <h1 className="text-[16px] font-bold">
                          <Link href={`/courses/${course?.id}`}>{course?.title}</Link>
                        </h1>
                        <p className="text-[12px] font-normal">
                          <FontAwesomeIcon
                            icon={faVideo}
                            className="text-[#B9802A] text-[14px] mr-1"
                          />
                          {course?.total_videos}
                        </p>
                      </td>
                      <td className="p-2 text-right">
                        <p className="text-[12px] font-semibold font-normal">
                          <FontAwesomeIcon
                            icon={faEye}
                            className="text-[#B9802A] text-[14px] mr-1"
                          />
                          {course?.watched_videos}/{course?.total_videos}
                        </p>
                      </td>
                      <td className="p-2 text-right">
                        <p className="text-[12px] font-semibold font-normal">
                        <FontAwesomeIcon
                            icon={faClock}
                            className="text-[#B9802A] text-[14px] mr-1"
                          />
                          {secondsToHMS(course?.course_duration)}
                        </p>
                      </td>
                    </tr>
                  ))}
              </tbody>
            </table>
          </div>
          ) : <div className="pr-2 h-[280px] flex items-center justify-center font-semibold">You have not enrolled in any courses.</div>}
        </>
      )}
    </>
  );
}
